/*
	DevSaver Web Framework
	Copyright (c) 2013-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com				
*/

var STBHeader = Object.create(STBModule.prototype);
STBHeader.name		= "Header";
STBHeader.container = $(window);

STBHeader.init = function() {
	if ($("header .sec-nav").length) {
		$("body").addClass("withtopnav");
	}
}

STBHeader.toggleSticky = function(val) {
	var mainNav		= $(".main-nav"),
		elems		= mainNav.find(".navbar, .navbar-nav > li , .navbar-nav , .navbar-nav > li > a"),
		header		= $('.header'), 
		body		= $("body");

	if (STBLayoutScroller.isActive()){
		//header.addClass('sticky').removeClass("sticky2");
		//return false;
	}

	if (val) {
	
		header.addClass('sticky');

		//add the bgclass if exists
		if (body.hasClass("menu-open") && mainNav.attr("data-bgs") != ""){
			mainNav.removeClass(mainNav.attr("data-bg")).addClass(mainNav.attr("data-bgs"));
			header.removeClass(header.attr("data-bg")).addClass(header.attr("data-bgs"));

			if (mainNav.hasClass("ic")) {
				elems.removeClass("nc").addClass("ic");
			} else {
				elems.removeClass("ic").addClass("nc");
			}
		}

	} else {

		header.removeClass('sticky');

		//add the bgclass if exists
		if (body.hasClass("menu-open") && mainNav.attr("data-bg") != ""){
			mainNav.removeClass(mainNav.attr("data-bgs")).addClass(mainNav.attr("data-bg"));
			header.removeClass(header.attr("data-bgs")).addClass(header.attr("data-bg"));

			if (mainNav.hasClass("ic")) {
				elems.removeClass("nc").addClass("ic");
			} else {
				elems.removeClass("ic").addClass("nc");
			}
		}

	}
}


STBHeader.menuChangeScheme = function(nav) {
	//check for ic / nc
	var scheme = "";

	//check what scheme class this menu has
	if (nav.hasClass("ic"))	{ 
		scheme = "ic";
	} else { 
		if (nav.hasClass("nc")) {
			scheme = "nc";
		}
	}
			
	//detect all menu items that can have a scheme class
	var navItems = nav.find(".navbar-nav, .navbar-nav > li, .navbar-nav > li > a , .navbar-nav > li > span");

	//remove the old classes and add the new one

	if (navItems.length){
		navItems.removeClass("ic nc").addClass(scheme);
	}
}

STBHeader.toggleCollapse = function (status) {
	var body	= $("body"), 
		mainNav = $(".main-nav .collapse"),
		secNav	= $(".sec-nav .collapse"),
		menuBar = $(".main-nav"),
		logoBar = $(".navbar-brand");

	if (status === true) {
		body.removeClass("menu-open").addClass("menu-close");

		//backup the old class
		if (!mainNav.attr("data-old")) {
			mainNav.attr("data-old" , mainNav.attr("class"));
		}

		mainNav.removeClass("nc ic").addClass(mainNav.attr("data-bg-collapse"));

		//backup the old class
		if (!secNav.attr("data-old")) {
			secNav.attr("data-old" , secNav.attr("class"));
		}

		secNav.removeClass("nc ic").addClass(secNav.attr("data-bg-collapse"));

		//backup the old class
		if (!logoBar.attr("data-old")) {
			logoBar.attr("data-old" , logoBar.attr("class"));
		}

		logoBar.removeClass("nc ic").addClass(logoBar.attr("data-bg-collapse"));

		STBHeader.menuChangeScheme(mainNav);
		STBHeader.menuChangeScheme(secNav);

	} else {

		if (body.hasClass("menu-open")) {
			return true;
		}

		body.removeClass("menu-close").addClass("menu-open");

		//remove the display: none from all drops
		$(".dropdown-menu").css("display" , "");

		//mainNav.attr("data-old" , mainNav.attr("class"));

		if (mainNav.attr("data-old") != "") {
			mainNav.removeClass(mainNav.attr("data-bg-collapse")).addClass(mainNav.attr("data-old"));
			STBHeader.menuChangeScheme(mainNav);
		}

		if (secNav.attr("data-old") != "") {
			secNav.removeClass(secNav.attr("data-bg-collapse")).addClass(secNav.attr("data-old"));
			STBHeader.menuChangeScheme(secNav);
		}

		if (logoBar.attr("data-old") != "") {
			logoBar.removeClass(logoBar.attr("data-bg-collapse")).addClass(logoBar.attr("data-old"));
		}

	}


}

STBHeader.autoCollapse = function() {

	if ($("body").attr("data-menu-collapse")) {

		var width = document.documentElement.clientWidth || document.body.clientWidth;
			body = $("body"),
			max = body.attr("data-menu-collapse"),
			navs = body.find("header .navbar");

			if (max < 500) {
				max = 500;
			}

			if (width < max) {
				navs.removeClass("navbar-expand");
				STBHeader.toggleCollapse(true);
			} else {
				navs.addClass("navbar-expand");
				STBHeader.toggleCollapse(false);
				STBHeaderDropDown.updateWidth();
			}

			setTimeout(function() {
				body.removeClass("menu-working");
			}, 100)

	} else {
		if ($("body").hasClass("menu-open")) {
			$("header .navbar").addClass("navbar-expand");
		}
	}

}

STBHeader.onMouseUp = function() {
        var onMouseUp = function (e) {
			
            var $body = $("body"), $container, $menu;

            if ($body.hasClass("moveMainNav")) {
                $container = $(".main-nav .navbar-collapse");
                $menu = $(".menu-button");
            } else if ($body.hasClass("moveSecNav")) {
                $container = $(".sec-nav .navbar-collapse");
                $menu = $(".top-menu-button");
            } else {
                return true;
            }

            if ((!$container.is(e.target) && $container.has(e.target).length === 0) && (!$menu.is(e.target) && $menu.has(e.target).length === 0)) {
                e.preventDefault();
                $menu.trigger("click");
            }
        };

        $(document).bind('mouseup touchend', onMouseUp);
}



STBHeader.btnMainNav = function() {
	$('.menu-button').on('click', function () {
		var $body = $("body");

		$body.toggleClass('moveMainNav');

		if (!$body.hasClass("moveMainNav")) {
			var $dropNotSocial = $(".main-nav li.dropdown:not(.dropdown-social)");

			$dropNotSocial.removeClass("open");
			$dropNotSocial.find(".dropdown-menu").hide();

			STBUtils.unfreezeBrowser();

		} else {
			STBUtils.freezeBrowser();
		}

	});
}

STBHeader.btnSecNav = function() {
	$('.top-menu-button').on('click', function () {
		var $body = $("body");

		$body.toggleClass('moveSecNav');

		if (!$body.hasClass("moveSecNav")) {
			var $dropNotSocial = $(".sec-nav li.dropdown:not(.dropdown-social)");

			$dropNotSocial.removeClass("open");
			$dropNotSocial.find(".dropdown-menu").hide();

			STBUtils.unfreezeBrowser();

		} else {
			STBUtils.freezeBrowser();

		}

	});
}

STBHeader.setContainer = function(container) {
	STBHeader.container = container;
}

STBHeader.stickyMenu = function() {

	if (STBLayoutScroller.isActive()){
		return false;
	}

	var $obj				= STBHeader.container,
		$windowHeight		= STBHeader.container.height(),
		$wrapper			= $('.wrapper'),
		$header				= $('.header'),
		$secNav				= $('.header .sec-nav'),                
		$mainNav			= $(".main-nav"),
		$headerHeight		= $header.outerHeight(),
		$homeSectionHeight	= 0,
		sticky				= $("body").attr("data-menu-sticky"),
		elems				= $mainNav.find(".navbar, .navbar-nav > li , .navbar-nav , .navbar-nav > li > a");

	if (!(typeof sticky !== typeof undefined && sticky !== false)) {
		$("body").attr("data-menu-sticky" , "false");
	}

	if ($("body").find(".topintro").length > 0 && $("body").attr('data-topintro-menu') === 'true') {
		$homeSectionHeight = $windowHeight - $headerHeight;
	} else {
		if ($(".topintro").length > 0) {
			$homeSectionHeight = $windowHeight;
		} 
	}

	if ($obj.scrollTop() > $homeSectionHeight) {

		if (STBHeader.pageHasSticky() && !STBHeader.pageIsSticky()) {
			var $secondHeaderHeight = $header.outerHeight();
			$wrapper.css('height', $secondHeaderHeight);

			STBHeader.toggleSticky(true);
		}

	} else {

		if (STBHeader.pageHasSticky() && STBHeader.pageIsSticky()) {
			$wrapper.css('height', 'auto');
			STBHeader.toggleSticky(false);
		}

	}

	if ($header.hasClass('sticky') && $secNav.length > 0) {
		if ($obj.scrollTop() > $homeSectionHeight + 300) {
			
			if (!$header.hasClass("sticky2")) {
				$header.addClass('sticky2');
			}
		} else {
			if ($header.hasClass("sticky2")) {
				$header.removeClass('sticky2');
			}
		}
	}

	if (!$secNav.length) {
		if ($header.hasClass('sticky') && $('body').hasClass('main-navbar-top')) {
			if ($obj.scrollTop() > $homeSectionHeight + 300) {

				if (!$header.hasClass("sticky3")) {
					$header.addClass('sticky3');
				}
			} else {
				if ($header.hasClass("sticky3")) {
					$header.removeClass('sticky3');
				}				
			}
		}
	}
}

STBHeader.pageHasSticky =  function() {
	return ($("body").attr("data-menu-sticky") == "true");
}

STBHeader.pageIsSticky =  function() {
	return ($("header").hasClass("sticky"));
}

STBHeader.pageHasOverContent = function() {
	return ($("body").attr("data-menu-over-title") == "true");
}

STBHeader.menuOverContent = function(status) {
	$("body").attr("data-menu-over-title" , status ? "true" : "false");
}

STBHeader.runOnScroll = function() {
	STBHeader.stickyMenu();
}

STBHeader.runOnReady = function() {
	STBHeader.init();
	STBHeader.onMouseUp();
	STBHeader.btnMainNav();
	STBHeader.btnSecNav();
	STBHeader.autoCollapse();
	STBHeader.stickyMenu();
}

STBHeader.runOnResize = function() {
	STBHeader.autoCollapse();
}

site.registerModule(STBHeader);